#include <iostream>
#include <vector>
#include <random>

using namespace std;

mt19937 rnd(time(nullptr));

bool check_pal(long num) {
    string str = to_string(num);
    bool res = true;
    for (long i = 0; i < str.size(); ++i) {
        if (str[i] != str[str.size() - 1 - i])
            res = false;
    }
    return res;
}


int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    vector<long> dp(1000, 1e9 + 7);
    dp[0] = 0;
    vector<long> pal;
    for (long i = 1; i < 1000; ++i) {
        if (check_pal(i))
            pal.push_back(i);
    }
    for (long i = 1; i < 1000; ++i) {
        for (auto p: pal) {
            if (p <= i)
                dp[i] = min(dp[i], dp[i - p] + 1);
        }
    }
    long t;
    cin >> t;
    for (long i = 0; i < t; ++i) {
        long num;
        cin >> num;
        cout << dp[num] << endl;
    }
    return 0;
}
